/*
 * Decompiled with CFR 0.152.
 */
package frederic.extraaccessories.items;

import baubles.api.BaubleType;
import baubles.common.container.InventoryBaubles;
import baubles.common.lib.PlayerHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import frederic.extraaccessories.AddedItemsBlocks;
import frederic.extraaccessories.api.ItemBaubles;
import frederic.extraaccessories.handler.GuiHandler;
import frederic.extraaccessories.helper.ItemNBTHelper;
import frederic.extraaccessories.inventory.InventoryItemStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class ItemHeartAmulet
extends ItemBaubles {
    private static final String TAG_BAUBLE_UUID_MOST = "baubleUUIDMost";
    private static final String TAG_BAUBLE_UUID_LEAST = "baubleUUIDLeast";
    public static List<String> damageNegations = new ArrayList<String>();
    public int healthAmmount = 0;
    Multimap<String, AttributeModifier> attributes = HashMultimap.create();

    public ItemHeartAmulet() {
        this.func_77655_b("heart_amulet");
        this.func_111206_d("extraaccessories:heart_relic".substring(5));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
        damageNegations.add(DamageSource.field_76371_c.field_76373_n);
        damageNegations.add(DamageSource.field_76372_a.field_76373_n);
        damageNegations.add(DamageSource.field_76370_b.field_76373_n);
    }

    public void onValidPlayerWornTick(ItemStack stack, EntityPlayer player) {
        if (player.func_70027_ad()) {
            player.func_70066_B();
        }
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer && ItemHeartAmulet.getHeartAmulet(player = (EntityPlayer)event.entityLiving) != null && damageNegations.contains(event.source.field_76373_n)) {
            event.setCanceled(true);
        }
    }

    public BaubleType getBaubleType(ItemStack arg0) {
        return BaubleType.AMULET;
    }

    public static ItemStack getHeartAmulet(EntityPlayer player) {
        InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
        ItemStack stack1 = baubles.func_70301_a(0);
        return ItemHeartAmulet.isHeartAmulet(stack1) ? stack1 : null;
    }

    private static boolean isHeartAmulet(ItemStack stack) {
        return stack != null && stack.func_77973_b() == AddedItemsBlocks.heart_amulet;
    }

    @Override
    public void onEquippedOrLoadedIntoWorld(ItemStack stack, EntityLivingBase player) {
        this.attributes.clear();
        this.fillModifiers(this.attributes, stack);
        player.func_110140_aT().func_111147_b(this.attributes);
    }

    public static UUID getBaubleUUID(ItemStack stack) {
        long most = ItemNBTHelper.getLong(stack, TAG_BAUBLE_UUID_MOST, 0L);
        if (most == 0L) {
            UUID uuid = UUID.randomUUID();
            ItemNBTHelper.setLong(stack, TAG_BAUBLE_UUID_MOST, uuid.getMostSignificantBits());
            ItemNBTHelper.setLong(stack, TAG_BAUBLE_UUID_LEAST, uuid.getLeastSignificantBits());
            return ItemHeartAmulet.getBaubleUUID(stack);
        }
        long least = ItemNBTHelper.getLong(stack, TAG_BAUBLE_UUID_LEAST, 0L);
        return new UUID(most, least);
    }

    @Override
    public void onUnequipped(ItemStack stack, EntityLivingBase player) {
        this.attributes.clear();
        this.fillModifiers(this.attributes, stack);
        player.func_110140_aT().func_111148_a(this.attributes);
    }

    public void fillModifiers(Multimap<String, AttributeModifier> attributes, ItemStack stack) {
        InventoryItemStorage inv = new InventoryItemStorage(stack);
        int hp = 0;
        for (ItemStack s : inv.inventory) {
            if (s == null) continue;
            hp += s.field_77994_a;
        }
        attributes.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(ItemHeartAmulet.getBaubleUUID(stack), "Health", (double)(hp * 2), 0));
    }

    @Override
    public ItemStack func_77659_a(ItemStack is, World world, EntityPlayer player) {
        if (player.func_70093_af()) {
            GuiHandler.openGui(GuiHandler.GuiID.HEARTAMULET, player);
        } else if (!world.field_72995_K) {
            int stackID = 0;
            InventoryBaubles baubles = PlayerHandler.getPlayerBaubles((EntityPlayer)player);
            if (baubles.func_70301_a(stackID) == null && baubles.func_94041_b(stackID, is)) {
                baubles.func_70299_a(stackID, is.func_77946_l());
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                this.onEquipped(is, (EntityLivingBase)player);
            } else if (baubles.func_70301_a(stackID) != null && baubles.func_94041_b(stackID, is)) {
                ItemStack fromSlot = baubles.func_70301_a(stackID);
                baubles.func_70299_a(stackID, null);
                baubles.func_70299_a(stackID, is.func_77946_l());
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, fromSlot);
                this.onEquipped(is, (EntityLivingBase)player);
            }
        }
        return is;
    }

    public void func_77624_a(ItemStack is, EntityPlayer player, List list, boolean flag) {
        InventoryItemStorage inv = new InventoryItemStorage(is);
        int hp = 0;
        for (ItemStack s : inv.inventory) {
            if (s == null) continue;
            hp += s.field_77994_a;
        }
        NBTTagCompound nbt = is.func_77978_p();
        list.add(StatCollector.func_74837_a((String)"inventory.heartamulet_additional_lore.name", (Object[])new Object[]{hp * 2}));
    }

    public int getItemsIn(ItemStack is) {
        InventoryItemStorage inv = new InventoryItemStorage(is);
        int hp = 0;
        for (ItemStack s : inv.inventory) {
            if (s == null) continue;
            hp += s.field_77994_a;
        }
        return hp;
    }

    public static enum SizeStorage {
        SIZE1(4);

        private final int size;

        private SizeStorage(int size) {
            this.size = size;
        }

        public int getSize() {
            return this.size;
        }
    }
}

